
function hasSelectedAttachments(){
	return (selectedAttachments && (selectedAttachments.length > 0));
}
function doCopyAttachments(){
	var mailid = selectedAttachments[0].mailid;
	invokeAppFunction('CopyAttachments', {mailid: mailid, attachments: selectedAttachments});
}
function clearAttachmentsSelected(){
	selectedAttachments = null;
	selectedAttachments = [];
	$('.mail_attachment_entry').removeClass('ui-selected');
}
function selectAttachment(mailid, itemIndex, attachFileName){
	var count = selectedAttachments.length;
	selectedAttachments[count] = {
		mailid: mailid,
		itemIndex: itemIndex,
		attachFileName: attachFileName
	}
}
function OpenAttachFile(mailid, itemIndex, attachFileName) {
	invokeAppFunction('OpenAttachFile', {
		mailid: mailid,
		itemIndex: itemIndex,
		attachFileName: attachFileName
	});
}
function DownloadAllAttachments(mailid) {
	invokeAppFunction('DownloadAllAttachments', {mailid: mailid});
}
function popupAttachmentMenu(mailid, x, y, bSelectAll){
	if (bSelectAll){
		invokeAppFunction('OnPopupAttachmentMenu', {
			mailid: mailid,
			selectAll: true,
			x: x,
			y: y
		});
	}else{
		invokeAppFunction('OnPopupAttachmentMenu', {
			mailid: mailid,
			selectAll: false,
			attachments: selectedAttachments,
			x: x,
			y: y
		});
	}
}

function makeAttachmentSelectable(mailid) {
    var attachmentArea = $('#attachment_area_' + mailid);
    var attachmentDragStart = false;
	attachmentArea.selectable({
		filter: 'li',
		stop: function() {
			selectedAttachments = null;
			selectedAttachments = [];
			var selectedElement = $('li.ui-selected', attachmentArea);
			for (var i=0; i<selectedElement.length; i++) {
				var element = $(selectedElement[i]);
				var mailid = element.attr('mailid');
				var itemIndex = element.attr('itemIndex');
				var attachFileName = element.attr('attachFileName');
				if (itemIndex == 'undefine') continue;
				selectAttachment(mailid, itemIndex, attachFileName);
			}
		},
		start: function() {
			clearContactSelected();
			clearAttachmentsSelected();
		},
		selected: function() {
		},
		unselected: function() {
		},
		selecting: function() {
		},
		unselecting: function() {
		}
	});
}